<?php
if (!class_exists('DBSEO')) { die('No direct loading allowed.'); }

// #############################################################################
// Showthread class

/**
* Handles various functionality for Showthread
*/
class DBSEO_Script_Showthread
{
	/**
	 * Checks for and redirects to proper URLs if needed
	 *
	 * @param string $url
	 * @param boolean $fileExists
	 * @param boolean $fileExistsDeep
	 * 
	 * @return mixed
	 */
	public static function redirectUrl(&$url, &$fileExists, &$fileExistsDeep)
	{
		$_redirectUrl = $_urlFormat = '';
		
		if (!DBSEO::$config['dbtech_dbseo_rewrite_thread'])
		{
			// We're not rewriting this
			return false;
		}

		if (isset($_GET['goto']))
		{
			switch ($_GET['goto'])
			{
				case 'nextnewest':
					// Next thread
					$_urlFormat = 'Thread_Thread_Next';
					break;

				case 'nextoldest':
					// Previous thread
					$_urlFormat = 'Thread_Thread_Previous';
					break;
			}
		}
		else
		{
			$_threadId = intval($_GET['threadid'] ? $_GET['threadid'] : $_GET['t']);

			if ($_GET['p'] AND !$_GET['page'])
			{
				if (!$_threadId)
				{
					// Get post info
					$postInfo = DBSEO::getPostInfo($_GET['p'], true);
					$_threadId = $postInfo['threadid'];
				}

				// Get thread info
				$threadInfo = DBSEO::getThreadInfo($_threadId, true);

				// Get page info
				$_GET['page'] = self::getPostPage($threadInfo, $_GET['p']);

				// Set an anchor
				$postAnchor = '#post' . $_GET['p'];
			}

			$_urlFormat = 'Thread_Thread' . ((isset($_GET['page']) AND $_GET['page'] > 1) ? '_Page' : '');
		}

		if ($_urlFormat AND $_redirectUrl = DBSEO::createUrl($_urlFormat, $_GET))
		{
			// We had a redirect URL, so get to it!							
			DBSEO::safeRedirect($_redirectUrl . $postAnchor, array('', 't', 'p', 'threadid', 'postid', 'page', 'viewfull', ($_GET['pp'] == DBSEO::$config['maxposts']) ? 'pp' : ''));
		}
		
		return true;
	}

	/**
	 * Replace urls
	 *
	 * @param string $urlPrefix
	 * @param string $url
	 * @param string $urlAttributes
	 * @param string $urlSuffix
	 * @param string $inTag
	 * @param string $closeTag
	 * 
	 * @return string
	 */
	public static function replaceUrls(&$_preventProcessing, &$_seoParameters, &$urlPrefix, &$url, &$urlSuffix, &$inTag, &$_urlScript, &$_urlPlace, &$_urlParameters, &$_removeAllParameters, &$_cmsUrlAppend, &$nofollow, &$follow)
	{
		$newUrl = $_urlFormat = '';

		if (!DBSEO::$config['dbtech_dbseo_rewrite_thread'])
		{
			// We're not rewriting this
			return $newUrl;
		}

		if (preg_match('#^post(\d+)$#', $_urlPlace, $matches))
		{
			// Extract post ID
			$_seoParameters['p'] = $matches[1];

			$_seoParameters['threadid'] = intval($_seoParameters['threadid'] ? $_seoParameters['threadid'] : $_seoParameters['t']);
			if (!$_seoParameters['page'])
			{
				if (!$_seoParameters['threadid'])
				{
					// Get post info
					$postInfo = DBSEO::getPostInfo($_seoParameters['p'], true);
					$_seoParameters['threadid'] = $postInfo['threadid'];
				}

				// Get thread info
				$threadInfo = DBSEO::getThreadInfo($_seoParameters['threadid'], true);

				// Get page info
				$_seoParameters['page'] = self::getPostPage($threadInfo, $_seoParameters['p']);
			}
		}

		if (
			(isset($_seoParameters['p']) AND $_seoParameters['p']) OR 
			(isset($_seoParameters['postid']) AND $_seoParameters['postid'])
		)
		{
			if ($_seoParameters['do'])
			{
				// This only works for showpost URLs
				return $newUrl;
			}

			if ($newUrl = DBSEO::createUrl('Thread_Thread_GoToPost', $_seoParameters))
			{
				if ($_urlPlace)
				{
					// Get rid of hash tags
					$newUrl = preg_replace('|#.*|', '', $newUrl);
				}
			}
		}
		else if (isset($_seoParameters['goto']))
		{
			switch ($_seoParameters['goto'])
			{
				case 'newpost':
					// Next thread
					$_urlFormat = 'Thread_Thread_NewPost';
					break;

				case 'lastpost':
					// Previous thread
					$_urlFormat = 'Thread_Thread_LastPost';
					break;

				case 'nextnewest':
					// Next thread
					$_urlFormat = 'Thread_Thread_Next';
					break;

				case 'nextoldest':
					// Previous thread
					$_urlFormat = 'Thread_Thread_Previous';
					break;
			}

			if ($_urlFormat)
			{
				// We had an url format
				$newUrl = DBSEO::createUrl($_urlFormat, $_seoParameters);
			}
		}
		else
		{
			// Plain old thread URL
			$newUrl = DBSEO::createUrl('Thread_Thread' . (isset($_seoParameters['page']) ? '_Page' : ''), $_seoParameters);
		}

		if ($newUrl)
		{
			$_urlScript = $newUrl;
			unset(
				$_seoParameters['p'], 			$_seoParameters['post'], 		$_seoParameters['postid'], 
				$_seoParameters['viewfull'], 	$_seoParameters['t'], 			$_seoParameters['page'], 
				$_seoParameters['pagenumber'], 	$_seoParameters['threadid'], 	$_seoParameters['goto']
			);

			if (
				$_seoParameters['pp'] == $GLOBALS['perpage'] OR 
				$_seoParameters['pp'] == $GLOBALS['vbulletin']->userinfo['maxposts']
			)
			{
				// Default perpage
				unset($_seoParameters['pp']);
			}
		}

		return $newUrl;
	}

	/**
	 * Create URL
	 *
	 * @param string $_seoParameters
	 * 
	 * @return string
	 */
	public static function createUrl($_seoParameters)
	{
		$newUrl = $_urlFormat = '';

		if (!DBSEO::$config['dbtech_dbseo_rewrite_thread'])
		{
			// We're not rewriting this
			return $newUrl;
		}

		if (preg_match('#^post(\d+)$#', $_urlPlace, $matches))
		{
			// Extract post ID
			$_seoParameters['p'] = $matches[1];

			$_seoParameters['threadid'] = intval($_seoParameters['threadid'] ? $_seoParameters['threadid'] : $_seoParameters['t']);
			if (!$_seoParameters['page'])
			{
				if (!$_seoParameters['threadid'])
				{
					// Get post info
					$postInfo = DBSEO::getPostInfo($_seoParameters['p'], true);
					$_seoParameters['threadid'] = $postInfo['threadid'];
				}

				// Get thread info
				$threadInfo = DBSEO::getThreadInfo($_seoParameters['threadid'], true);

				// Get page info
				$_seoParameters['page'] = self::getPostPage($threadInfo, $_seoParameters['p']);
			}
		}

		if (
			(isset($_seoParameters['p']) AND $_seoParameters['p']) OR 
			(isset($_seoParameters['postid']) AND $_seoParameters['postid'])
		)
		{
			if ($_seoParameters['do'])
			{
				// This only works for showpost URLs
				return $newUrl;
			}

			// Create URL
			$_urlFormat = 'Thread_Thread_GoToPost';
		}
		else if (isset($_seoParameters['goto']))
		{
			switch ($_seoParameters['goto'])
			{
				case 'newpost':
					// Next thread
					$_urlFormat = 'Thread_Thread_NewPost';
					break;

				case 'lastpost':
					// Previous thread
					$_urlFormat = 'Thread_Thread_LastPost';
					break;

				case 'nextnewest':
					// Next thread
					$_urlFormat = 'Thread_Thread_Next';
					break;

				case 'nextoldest':
					// Previous thread
					$_urlFormat = 'Thread_Thread_Previous';
					break;
			}
		}
		else
		{
			// Plain old thread URL
			$_urlFormat = 'Thread_Thread' . (isset($_seoParameters['page']) ? '_Page' : '');
		}

		if (!$_urlFormat)
		{
			// We're not rewriting this
			return $newUrl;
		}

		return DBSEO::createUrl($_urlFormat, $_seoParameters);
	}

	/**
	 * Gets the page the specified post is on
	 *
	 * @param array $threadInfo
	 * @param integer $postId
	 * 
	 * @return integer
	 */
	private static function getPostPage($threadInfo, $postId)
	{
		if (!isset($GLOBALS['vbulletin']))
		{
			if ($_COOKIE[DBSEO::$config['_cookieprefix'] . 'userid'])
			{
				if (($userInfo = DBSEO::$datastore->fetch('postpage.' . $_COOKIE[DBSEO::$config['_cookieprefix'] . 'userid'])) === false)
				{
					// Grab our page settings
					$userInfo = DBSEO::$db->generalQuery('
						SELECT maxposts, (options & 32768) AS postorder
						FROM $user
						WHERE userid = ' . $_COOKIE[DBSEO::$config['_cookieprefix'] . 'userid'] . '
					', true);

					// Build the cache
					DBSEO::$datastore->build('postpage.' . $_COOKIE[DBSEO::$config['_cookieprefix'] . 'userid'], $userInfo);
				}
			}
			else
			{
				// Guest
				$userInfo = array('maxposts' => DBSEO::$config['maxposts'], 'postorder' => 0);
			}
		}
		else
		{
			// We have vB info
			$userInfo = $GLOBALS['vbulletin']->userinfo;
		}

		if ($userInfo['maxposts'] <= 0)
		{
			// Set forum maxposts
			$userInfo['maxposts'] = DBSEO::$config['maxposts'];
		}

		$replyCount = intval(preg_replace('#[^0-9]#', '', $threadInfo['replycount'])) + 1;
		$page = 1;

		if ($replyCount <= $userInfo['maxposts'])
		{
			// This will always be page 1
			return $page;
		}

		// See if we can't save some queries
		switch ($postId)
		{
			case $threadInfo['firstpostid']:
				// First post in thread
				$page = ($userInfo['postorder'] == 1 ? ceil($replyCount / $userInfo['maxposts']) : 1);
				break;

			case $threadInfo['lastpostid']:
				// Last post in thread
				$page = ($userInfo['postorder'] == 0 ? ceil($replyCount / $userInfo['maxposts']) : 1);
				break;

			default:
				// Grab our page settings
				$postPage = DBSEO::$db->generalQuery('
					SELECT CEIL(COUNT(*) / ' . $userInfo['maxposts'] . ') AS page
					FROM $post
					WHERE postid ' . ($userInfo['postorder'] == 1 ? '>=' : '<=') . ' ' . $postId . '
						AND threadid = ' . $threadInfo['threadid'] . '
				', true);

				$page = $postPage['page'];
				break;
		}

		return $page;
	}
}
?>